///////////////////////////////////////////////////////////////////////////////
//
//   CONEXANT SYSTEMS INC - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1292.C - Message 1292 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1292 messages.
//
//   Originator : Hao Q. Phung
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\msg1292.c_v  $
//   
//      Rev 1.0   13 Dec 1999 09:43:16   dangmk
//    
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>
#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1292 message from the ZMsgBuf.
//
void Bld1292(tMSGBUF *ZMsgBuf, tMSG1292 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                        , ZMsgBuf, 1);     // message preamble
   PutShort  (1292                          , ZMsgBuf, 2);     // message number
   PutShort  (21                            , ZMsgBuf, 3);     // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);     // message ack/nack request

}                                      
                                     
   
//   Display a Zodiac 1292 message from the ZMsgBuf.
//
//void Show1292(tMSG1292 *Msg)
//{
//}                                                 
                                      
                                           
